C     Subprogram VGpar
C    This subprogram calculates parameters of the van Genuchten's
C    equation of soil water retention: ThR, ThS, Alpha,n, m
C    The van Genuchten's equation is used in its traditional form:
C       Theta = (ThS-ThR)/(1+(alpha*P)^n)^(1-1/n) 
C    where Theta stands for volumetric water content and P stands
C    for suction (or for absolute value of the matric potential)
C    The program uses raw water retention data
C
C    Input data:
C    y - water content (cm3/cm3)
C    x - suction (cm)
C    nob - number of observations
C    b - van Genuchten parameters
C    np - number of parameters
C    mit - maximun number of iterations
C +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C +   The code is modification of van Genuchten, M.Th. 1980. Determining transport     +
C  +   parameters from solute displacement experiments. Research report No.118,         +
C  +   U.S. Salinity Laboratory, USDA-ARS-AR, Riverside, California.                                +
C  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      subroutine VGpar(x,y,nob,b,np,mit)
*
      dimension y(nob),x(nob),f(50),r(50),st(5),b(5),e(5),
     .          c(10), p(10), q(10), a(10,10), d(10,10),
     .          delz(50,10),dz(50)
*
      data eps /0.0005/
*
	b(1)=0.001
	b(2)=y(1)
	b(3)=0.01
	b(4)=1.5
      IER=0
      ga = 0.02
      sumb = 0.0
      call model(b,np,f,nob,x)
      do 10 k = 1,nob
      z = y(k) - f(k)
      r(k) = z
      if(abs(z) .gt. 1.0e-37) sumb = sumb + z * z
 10   continue
*
      do 200 nit = 1,mit
      ssq = sumb
      ga = 0.1 * ga
      do 30 j = 1,np
      temp = b(j)
      b(j) = 1.01 * b(j)
      call model(b,np,dz,nob,x)
      do 15 i = 1,nob       
      delz(i,j) = dz(i)
 15   continue
      sum = 0.0 
      do 20 k = 1,nob
      delz(k,j) = 100.0 * (delz(k,j) - f(k))
      tmp = delz(k,j) * r(k)
      sum = sum + tmp
 20   continue
      q(j) = sum / b(j)
      b(j) = temp
      c(j) = temp
 30   continue
      sum3 = 0.0
      do 60 i = 1,np
      do 50 j = 1,i
      sum = 0.0
      do 40 k = 1,nob
      temp = delz(k,i) * delz(k,j)
      sum = sum + temp
 40   continue
      d(j,i) = sum / (b(j) * b(i))
      d(i,j) = d(j,i)
 50   continue
      e(i) = sqrt(d(i,i))
      If(e(i).LE.0.) then
       IER=1
       Goto 500
      Endif
      q(i) = q(i) / e(i)
      if(abs(q(i)) .gt. 1.0e-37) sum3 = sum3 + q(i) * q(i)
 60   continue
 70   do 90 i = 1,np
      do 80 j = 1,i
      a(j,i) = d(j,i) / e(j) / e(i)      
      a(i,j) = a(j,i)
 80   continue
 90   continue
      do 100 i = 1,np
      p(i) = q(i)
 100  a(i,i) = a(i,i) + ga
      call matinv(a,np,p)
      sum1 = 0.0
      sum2 = 0.0
      do 110 i = 1,np
      temp = p(i) * q(i)
      sum1 = sum1 + temp
      temp = p(i) * p(i)
      sum2 = sum2 + temp
 110  continue
      an = sqrt((sum1/sum2)*(sum1/sum3))
      angle = 57.2958 * atan((sqrt(abs(1-an**2)))/an)
      step = 1.0
 120  do 130 i = 1,np
 130  b(i) = p(i) * step / e(i) + c(i)
      do 140 i = 1,np        
      if(c(i)*b(i) .le. 0.0) go to 160
 140  continue
      sumb = 0.0
      call model(b,np,f,nob,x)
      do 150 k = 1,nob
      z = y(k) - f(k)
      r(k) = z
      if(abs(z) .gt. 1.0e-37) sumb = sumb + z*z
 150  continue
      if(sumb-ssq .lt. 1.0e-8) go to 180
 160  if(angle .gt. 30.0) go to 170
      step = 0.5 * step
      go to 120
 170  ga = 10.0 * ga
      go to 70
 180  do 190 i = 1,np
      if(abs(c(i)-b(i)) .gt. eps*abs(b(i))) go to 200
 190  continue
      go to 210
 200  continue
 210  call matinv(d,np,p)
      sdev = sqrt(sumb/float(nob-np))   
C	sdev = sqrt(sumb/float(nob))	    
      do 220 i = 1,np
      e(i) = sqrt(amax1(d(i,i),1.0e-20))
      st(i) = e(i) * sdev
 220  continue
*
 500  return
      end
*
      subroutine matinv(a,np,b)
*
      dimension a(10,10),b(np),indx1(10),indx2(10)
*
      do 10 j = 1,np
 10   indx1(j) = 0
      i = 0
 20   amax = -1.0
      do 40 j = 1,np
      if(indx1(j) .ne. 0) go to 40
      do 30 k = 1,np
      if(indx1(k) .ne. 0) go to 30
      p = abs(a(j,k))
      if(p .le. amax) go to 30
      ir = j
      ic = k 
      amax = p
 30   continue
 40   continue
      if(amax .le. 0.0) go to 120
      indx1(ic) = ir
      if(ir .eq. ic) go to 60
      do 50 l = 1,np
      p = a(ir,l)
      a(ir,l) = a(ic,l)
      a(ic,l) = p
 50   continue
      p = b(ir)
      b(ir) = b(ic)
      b(ic) = p
      i = i + 1
      indx2(i) = ic
 60   p = 1.0 / a(ic,ic)
      a(ic,ic) = 1.0
      do 70 l = 1,np
      a(ic,l) = a(ic,l) * p
 70   continue
      b(ic) = b(ic) * p
      do 90 k = 1,np
      if(k .eq. ic) go to 90
      p = a(k,ic)
      a(k,ic) = 0.0
      do 80 l = 1,np
      a(k,l) = a(k,l) - a(ic,l) * p
 80   continue
      b(k) = b(k) - b(ic) * p
 90   continue
      go to 20
 100  ic = indx2(i)
      ir = indx1(ic)
      do 110 k = 1,np
      p = a(k,ir)
      a(k,ir) = a(k,ic)
      a(k,ic) = p
 110  continue
      i = i - 1
 120  if(i .gt. 0) go to 100
*
      return
      end    
*
      subroutine model(b,np,y,nob,x)
*
      dimension b(np),y(nob),x(nob)
       do i = 1,nob
         y(i)=b(1)+(b(2)-b(1))/(1+(b(3)*x(i))**b(4))**(1.-1/b(4))
      end do
      return
      end

