C	Grid for the STWIR Subroutine 
C	Programmed by: A. Guber

	Subroutine Grid(dx,nk)

C	nk - total number of nodes

	Real lam,Kd,Ks, Mum,Mur,Mus,Muw
	Common /ADE/ lam,Ks,tauA,tauD,Ro,depth,kd,Crain,So,
     *Sm,Aman,Bman,Er,RainM,Mum,Mur,Mus,Muw
     	common /plane2/ Cman,Sman
	Common /ParamFC/ ind,fPar(20)
	Common /GridADE/N1,N2,NP1,NM1,NM2,HX(251),HXS(250),XS(250),S(250),
     *				C(250),CJ(250),VJ(250),V(250),Cm(250)

	if (ind.eq.1) return

C	Parameters for FC transport
	lam=fPar(1)
	Ks=fPar(2)/36.		!conversion [cm/h] into [m/sec]
	tauA=fPar(3)/3600.  !conversion [1/h] into [1/sec]
	tauD=fPar(4)/3600.	!conversion [1/h] into [1/sec]
	Kd=1-fPar(5)
	Aman=fPar(6)
	Bman=fPar(7)
	Sm=fPar(8)*1.0e+4 ! conversion [CFU/cm2] into [CFU/m2]
	Er=fPar(9)
	So=fPar(10)
	Crain=fPar(11)*1.e+6 ! conversion [CFU/ml] into [CFU/m3]
	depth=fPar(12)
	Mum=fPar(13)/3600.  !conversion [1/h] into [1/sec]
	Mur=fPar(14)/3600.  !conversion [1/h] into [1/sec]
	Mus=fPar(15)/3600.  !conversion [1/h] into [1/sec]
	Muw=fPar(16)/3600.  !conversion [1/h] into [1/sec]

	Sman=0.0
	N2=nk
C	Grid for FC transport
      NP1=N2+1
      NM1=N2-1
      NM2=N2-2
      HX(1)=0.
      HX(NP1)=0.0
      XS(1)=0.0
	S(1)=So
	CJ(1)=0.0
	Cm(1)=0.0
	HXS(1)=0.5*dx
	VJ(1)=0.0
	DO J=2,N2
	   XS(J)=(J-1)*dx
         HX(J)=XS(J)-XS(J-1)
	   HXS(J)=HX(J)
	   S(J)=So
	   CJ(J)=0.0
	   Cm(j)=0.0
	   VJ(J)=0.0	
      END DO
	HXS(N2)=0.5*dx
	Return
	End
