C-------------------------------------------------------------I
C															I
C STWIR (Simulator of Transport With Infiltration and Runoff)	I
C															I
C-------------------------------------------------------------I
C     Transport equation:										I
C     d(WC)/dt=d/dx(DdC/dx)-d(VC)/dx-E*C-G					I
C     x=0: NAL0*D*dC/dx=NBE0*V*(C-C0)							I
C     x=L: NALL*D*dC/dx=NBEL*V*(C-CL)							I
C     Solution for 1 time step								I
c     conservative scheme, with "front limitation"			I
C-------------------------------------------------------------I
C     Ks - exchange rate between runoff and soil water [1/sec]I   ! corrected oct 2012 AY
C     Kd - distribution coefficient for FC infiltration (0-1) I
C     Kd=0  - no FC losses with infiltration				    I   
C     tauA, tauD - adsorption/desorption rate in soil	[1/sec] I
C     Ro - soil bulk density	[g/m3]							I
C     depth - depth of exchange zone	[m]						I
C     Cman - FC content in the released manure [CFU/m3]		I
C     Sm - initial FC content in the manure [CFU/m2]			I
C     So - initial FC content in the soil [CFU/g]				I
C     S - current FC content in the soil [CFU/g]				I
C     C - FC content in the runoff water [CFU/m3]				I
C     C0 - FC content in the runoff water from upward			I
C          segment[CFU/m3]									I
C     Cm - FC content in soil solution water [CFU/m3]			I
C     ind - type of FC-soil interaction model					I
C	ind=2 interaction with soil water and then solid face	I
C	ind=3 direct runoff interaction with soil solid face	I
C-------------------------------------------------------------I

!Written by Alexander Yakirevich, University of Beer Sheva, Israel
!Release date 09/30/08
!Modified by Andrey Guber, ARS-USDA
!Last update 10/18/12  AY

      SUBROUTINE STWIR(X,C,CJ,Cm,S,W,WJ,E,G,D,V,VJ,HXS,HX,SI,
     *C0,CL,TAU,NAL0,NBE0,NALL,NBEL,N,NP1,NM1,NM2,Tcurrent)
      DIMENSION X(N),C(N),CJ(N),Cm(N),S(N),W(N),WJ(N),E(N),G(N),D(N),
     *V(N),VJ(N),HXS(N),HX(NP1),SI(NM2,4),B(6),
     *V05(501),C05(501),CJR(501),Cdummy(501),Zet2(501)
	Real Ks,kd,lam,kdt,Mum,Mur,Mus,Muw
	Common /ADE/ lam,Ks,tauA,tauD,Ro,depth,kd,Crain,So,
     *Sm,Aman,Bman,Er,RainM,Mum,Mur,Mus,Muw
	common /plane2/ Cman,Sman
	Common /ParamFC/ ind,fPar(20)

	Ws=fpar(20)
!     Calculation maximum timestep : Courant number Co=V*TauCr/(W*HX)=0.2
        
      TAUMAX=TAU
      DO J=1,NM1
        IF(W(J).ge.1.e-10) then
         VV=abs(V(J))/W(J)
!        VV=abs(VJ(J))/min(W(J),WJ(J))
        ELSE
	   VV=0.
        END IF
        if (VV.gt.1.e-10) then
          TAUCOUR=0.25*HX(J+1)/VV
        else
          TAUCOUR=TAUMAX
        end if
        IF(TAUCOUR.lT.TAUMAX)TAUMAX=TAUCOUR
      ENDDO

      IF(TAUMAX.GE.TAU) then
	  NTCYCL=1
        TAUR=TAU	
      else           
        NTCYCL=INT(TAU/TAUMAX)+1
	  TAUR=TAU/NTCYCL
	END IF

	DO J=1,N
        CJR(J)=CJ(J)
      END DO	
	DO JTC=1,NTCYCL

!       calculation fluxes and concentrations in intermideate nodes (i+1/2)

       DO I=1,NM1
	  VR=VJ(I)+(V(I)-VJ(I))*JTC/NTCYCL
	  VRP=VJ(I+1)+(V(I+1)-VJ(I+1))*JTC/NTCYCL
c        V05(I)=0.5*(VJ(I)+VJ(I+1))
        V05(I)=0.5*(VR+VRP)
	  IF(V05(I).ge.0.) then
	    IF(I.eq.1) then
		  C1=C0
		  C2=C0
		  C3=CJR(1)
            X1=X(1)-2.*HX(2)	
            X2=X(1)   -HX(2)	
            X3=X(1)
          else
	      IF(I.eq.2) then
		    C1=C0
		    C2=CJR(1)
		    C3=CJR(2)
              X1=X(1)-HX(2)	
              X2=X(1)	
              X3=X(2)
            else
  		    C1=CJR(I-2)
		    C2=CJR(I-1)
		    C3=CJR(I)
              X1=X(I-2)	
              X2=X(I-1)	
              X3=X(I)
            END IF
          END IF
        ELSE
	    IF(I.eq.N-1) then
		  C3=CJR(N)
		  C2=CJR(N)
		  C1=CJR(N)
            X3=X(N)+2.*HX(N)	
            X2=X(N)   +HX(N)	
            X1=X(N)
          else
	      IF(I.eq.N-2) then
		    C3=CJR(N)
		    C2=CJR(N)
		    C1=CJR(N-1)
              X3=X(1)+HX(N)	
              X2=X(N)	
              X1=X(N-1)
            else
  		    C3=CJR(I+3)
		    C2=CJR(I+2)
		    C1=CJR(I+1)
              X3=X(I+3)	
              X2=X(I+2)	
              X1=X(I+1)
            END IF
          END IF
        END IF
        X12=X1*X1
        X22=X2*X2
        X32=X3*X3

	  DET0=X2*X32+X1*X22+X3*X12-X12*X2-X3*X22-X1*X32
	  DET1=C1*X2*X32+C3*X1*X22+C2*X3*X12-C3*X12*X2-C1*X3*X22-C2*X1*X32	  				  			              
	  DET2=C2*X32+C1*X22+C3*X12-X12*C2-C3*X22-C1*X32
	  DET3=X2*C3+X1*C2+X3*C1-C1*X2-X3*C2-X1*C3
        a0=DET1/DET0
        a1=DET2/DET0
        a2=DET3/DET0 
        X05=X(I)+0.5*HX(I+1)
        C05E=a0+a1*X05+a2*X05*X05
c        IF(V05(I).gt.0.)then
         C05(I)=min(max(CJR(I),CJR(I+1)),max(min(CJR(I),CJR(I+1)),C05E))
c        else
c         C05(I)=min(max(CJR(I),CJR(I-1)),max(min(CJR(I),CJR(I-1)),C05E))
c        END IF
	 END DO
	
       DP12=0.
       VP12=0.
       DO J=1,N
        JM=J-1
        JP=J+1
        DM12=DP12
        VM12=VP12
        RHS=HXS(J)
	  RV=V(J)
        WW=WJ(J)+(W(J)-WJ(J))*JTC/NTCYCL
        WWJ=WJ(J)+(W(J)-WJ(J))*(JTC-1)/NTCYCL
        RW=WW*RHS/TAUR
        RWJ=WWJ*CJR(J)*RHS/TAUR


C	Concentration in released manure solution after die-off: Cman
	If(RainM.gt.1.e-10.and.Sman.lt.Sm) then
		if(Aman.EQ.0.0) then				
		    alfa=0.0361+0.8603*RainM*3.6e+5   ! Estimate alfa from rainfall rate if unknown[1/h]
	                    else
			alfa=Aman
		end if

	Cman=Er*exp(-Mum*Tcurrent)*alfa*Sm/(3.6e+5*RainM*
     *			(1+alfa*Bman*Tcurrent/3600.0)**(1+1/Bman)) ! [CFU/m3]
	else
	Cman=0.0
	end if
	If(J.eq.1) Sman=Sman+Cman*RainM*TAUR ! total released FC [CFU/m2]
		Zet3=1+(tauD+Mus)*TAUR
	select case(ind)
	  case(2)
C	Runoff FC interaction with soil water and then solid face

	Zet2(J)=depth*Ws/TAUR+depth*Ws*tauA/Zet3+Ks*WW+depth*Muw+Kd*E(J)
		RE=Ks*WW*(1-(Kd*E(J)+Ks*WW)/Zet2(J))+Kd*E(J)+Mur*WW      ! corrected oct 2012 AY             
		RG=G(J)-Cman*RainM-Ks*WW/Zet2(J)*(depth*Cm(J)*Ws/TAUR+
     +      Ro*depth*(tauD+Mus)*S(J)/Zet3)    ! Cman*RainM income from manure
	  case(3)
C	Runoff FC direct intraction with soil solid face	
		RE=depth*tauA*Ws+Kd*E(J)+Mur*WW+Ks*Kd*E(J)             ! corrected oct 2012 AY
     *		-TAUR*(tauD+Mus)*(tauA*depth*Ws+Ks*Kd*E(J))/Zet3   ! corrected oct 2012 AY
		RG=G(J)-Cman*RainM-Ro*depth*(tauD+Mus)*S(J)/Zet3       ! corrected oct 2012 AY
	end select



        IF(J.eq.1) then
C     NAL0=0 Concentration boundary condition
          IF(NAL0.eq.0) then
            B(1)=1.
            B(2)=0.
            B(3)=C0
            DP12=0.5*(D(J)+D(JP))/HX(JP)
          ELSE
C     NAL0=1 Flux boundary condition
            DP12=0.5*(D(J)+D(JP))/HX(JP)
            B(1)=RW+DP12+RV+RE
            B(2)=DP12
            B(3)=RWJ+RV*C0-RG

c            B(3)=RWJ+RV*(C0+CJR(1))-V05(J)*C05(J)-RG

          END IF
        ELSE
          IF(J.lt.N) THEN
            DP12=0.5*(D(J)+D(JP))/HX(JP)			 
            SI(JM,1)=DM12
            SI(JM,3)=DP12
            SI(JM,2)=RW+DM12+DP12+RE
		  SI(JM,4)=RWJ-RG-(V05(J)*C05(J)-V05(JM)*C05(JM))
		else
            IF(NALL.eq.0) then
              B(4)=0.
              B(5)=-1.
              B(6)=CL
            ELSE
              B(4)=DP12
              B(5)=RW+DP12+RE
              B(6)=-RWJ+RV*CL+RG

c              B(6)=-RWJ+RV*CJR(N)-V05(NM1)*C05(NM1)+RG
            END IF
          END IF
        END IF
       END DO
      CALL TSYSO(C,B,SI,NM1,N,NM2)
	 DO J=1,N
        WW=WJ(J)+(W(J)-WJ(J))*JTC/NTCYCL		! corrected oct 2012 AY
        IF(WW.le.1.e-5) then					! corrected oct 2012 AY
	      C(J)=0.							! corrected oct 2012 AY			
            Cdummy(J)=Cman					! corrected oct 2012 AY
          else								! corrected oct 2012 AY
            Cdummy(J)=C(J)					! corrected oct 2012 AY
        END IF
        CJR(J)=Cdummy(J)                      

C	Correced 10/03/12 AY
	select case(ind)
	    case(2)
 			Cm(j)=(Cm(j)*depth*Ws/TAUR+Ro*depth*(tauD+Mus)*S(j)/Zet3
     +		+(Kd*E(j)+Ks*WW)*Cdummy(j))/Zet2(j)                           ! corrected oct 2012 AY
			S(J)=(Ws*TAUR*tauA*Cm(J)/Ro+S(J))/Zet3                     ! corrected oct 2012 AY
	    case (3)
			S(j)=TAUR*Cdummy(J)*(depth*tauA*Ws+Ks*Kd*E(j))/            ! corrected oct 2012 AY
     *			(Zet3*depth*Ro)+S(j)/Zet3
     	end select
	 END DO	
  
      END DO
      RETURN
      END


C*****************************************************************
C------------------------------------------------------------*
C  Nonmonotone version of Thomas algorithm for eqs.          *
C  S(J-1,1)*Y(Y-1)-S(J-1,2)*Y(J)+S(J-1,3)*Y(J+1)+S(J-1,4)=0  *
C              J=1,N;  M=N-1; L=L-2                          *
C  B(1)*Y(1)=B(2)*Y(2)+B(3);   B(4)*Y(N-1)=B(5)*Y(N)+B(6)    *
C------------------------------------------------------------*
C
      SUBROUTINE TSYSO(Y,B,S,M,N,L)
      COMMON C(498,3)
      DIMENSION Y(N),B(6),S(L,4)
      P=B(1)
      Q=B(2)
      R=B(3)
      K=N-2
      Z=AMAX1(ABS(P),ABS(Q),ABS(R))
      P=P/Z
      Q=Q/Z
      R=R/Z
      C(1,1)=P
      C(1,2)=Q
      C(1,3)=R
      DO 4 I=1,K
      IF(ABS(P)-1.E-17)1,1,2
    1 P=Q
      Q=0.
      R=-R
      GO TO 3
    2 E=P
      A=S(I,1)
      P=S(I,2)*E-A*Q
      Q=S(I,3)*E
      R=A*R+S(I,4)*E
    3 Z=AMAX1(ABS(P),ABS(Q),ABS(R))
      P=P/Z
      Q=Q/Z
      R=R/Z
      J=I+1
      C(J,1)=P
      C(J,2)=Q
    4 C(J,3)=R
      D=P*B(5)-Q*B(4)
      E=(R*B(5)-Q*B(6))/D
      Y(N-1)=E
      Y(N)=(R*B(4)-P*B(6))/D
    5 IF(K.EQ.0)GO TO 14
      P=C(K,1)
      IF(ABS(P)-1.E-17)6,6,7
    6 E=(S(K,2)*E-S(K,3)*Y(K+2)-S(K,4))/S(K,1)
      Y(K)=E
      K=K-1
      GO TO 5
    7 Q=C(K,2)
      IF(ABS(Q)-ABS(P))8,8,9
    8 E=(Q*E+C(K,3))/P
      Y(K)=E
      K=K-1
      GO TO 5
    9 J=K
   10 J=J-1
      IF(J.EQ.0)GO TO 11
      IF(ABS(C(J,1))-ABS(C(J,2)))10,11,11
   11 J=J+1
      P=1.
      Q=0.
      DO 12 I=J,K
      R=C(I,1)
      Z=C(I,2)
      P=P*R/Z
   12 Q=(Q*R-C(I,3))/Z
      E=(E-Q)/P
      Y(J)=E
      K=K-1
      DO 13 I=J,K
      E=(C(I,1)*E-C(I,3))/C(I,2)
   13 Y(I+1)=E
      E=Y(J)
      K=J-1
      GO TO 5
   14 RETURN
      END

