// Macro Activity_process.ijm import Tex image files:
// "Activity.res", "Time_der.res" and "Fraction.res"
// from the directory used by Activity_time.m
// It calculates "Act_cor" as  "Activity" x "Fraction"  
// and removes pixels with with late detection time 
// Results are saved as Act_cor-RGB.RGB abd BW images
 
// Open original zymography imagges
run("Close All");
source_dir = getDirectory("Source Directory");
InRAW1=lastIndexOf(source_dir, "\\");
subdir1=substring(source_dir, 1, InRAW1);
InRAW2=lastIndexOf(subdir1, "\\");
subdir2=substring(source_dir, 1, InRAW2+1);
InRAW3=lastIndexOf(subdir2, "\\");
subdir3=substring(source_dir, 1, InRAW3+1);
subdir4=substring(source_dir, InRAW3+2, InRAW2+1);


Activity = source_dir + "Activity.res";
run("Text Image... ", "open=Activity scale=20");
rename("Activity");

Time_der = source_dir + "Time_der.res";
run("Text Image... ", "open=Time_der scale=20");
rename("Time_der");

Fraction = source_dir + "Fraction.res";
run("Text Image... ", "open=Fraction scale=20");
rename("Fraction");

imageCalculator("Multiply create", "Activity","Fraction");
rename("Act_cor");

selectWindow("Time_der");
run("Duplicate...", "title=Mask");

// Create mask to separate diffusion image and multiply "Mask" by "Activity" 
run("Conversions...", " ");
run("8-bit");
waitForUser("Run Threshold for MASK and click OK");
selectWindow("Mask");
run("Create Selection");
selectWindow("Act_cor");
run("Restore Selection");
setBackgroundColor(0, 0, 0);
run("Clear Outside");
run("Select None");
rename("Act_cor-BW");

// convert Act_cor to RGB 
setOption("ScaleConversions", false);
run("Conversions...", " ");
run("Duplicate...", "title=Act_cor-RGB");
// Apply look-up table to the greyscale image
run("physics");
run("Calibration Bar...", "location=[Upper Right] fill=White label=Black number=5 decimal=0 font=14 zoom=3 overlay");
selectWindow("Act_cor-BW");
Act_BW = source_dir + subdir4 + "-BW.tif";
saveAs("Tiff", Act_BW);
selectWindow("Act_cor-RGB");
Act_RGB = source_dir + subdir4 + "-RGB.jpg";
saveAs("Jpeg", Act_RGB);
