// Macros Calcualates histograms and Sums(Grey*Frequency) 
// for each MUF spot at a calibration image and fit MUF= a*Sums(Grey*Frequency)
// to all MUF spots.
// Histograms are saved in Histogram.txt and Sums (Grey*Frequency) to Totgrey.txt
// MUF mass [nmol or pmol] should be entered in line 10
// the calibration parameter a has units [MUF mass units/grey value/pixel]  


// Enter MUF mass for each calibration spot
MUF = newArray(0.5,1.25,2.5,5,10); 


run("Close All"); 
// Select dirrectory with zymography image
source_dir = getDirectory("Source Directory");
// Open image, crop it and get red chahnel
waitForUser("Open calibration image, select ROI including background and click OK");
Raw=getTitle();
run("Duplicate...", "title=Cropped");

// Select Channel used for zymography 
  Channel = newArray("All","R", "G", "B");
  Dialog.create("Select Channel");
  Dialog.addChoice("Channel:", Channel);
  Dialog.show();
  Channel = Dialog.getChoice();
print(Channel);

// Get calibration image in selected color  
if(Channel=="All") {
run("8-bit");
rename("Channel");
}
else {
run("Split Channels");
if(Channel=="R") {
selectWindow("Cropped (red)");
run("Duplicate...", "title=Channel");
}
if(Channel=="G") {
selectWindow("Cropped (green)");
run("Duplicate...", "title=Channel");
}
if(Channel=="B") {
selectWindow("Cropped (blue)");
run("Duplicate...", "title=Channel");
}
selectWindow("Cropped (red)");
close();
selectWindow("Cropped (blue)");
close();
selectWindow("Cropped (green)");
close();
selectWindow(Raw);
close();
}

// Select and remove background from the calibration image
selectWindow("Channel");
waitForUser("Select Background and click OK");
getStatistics(area, mean, min, max, std, histogram);
run("Select None");
run("Subtract...", "value=[mean]");

// Identify MUF spots on the image
run("Duplicate...", "title=Mask");
waitForUser("Threshold Mask and click OK");
run("Divide...", "value=255 stack");
imageCalculator("Multiply create", "Channel","Mask");
rename("Clean");
selectWindow("Mask");
close();
selectWindow("Channel");
close();

// Select number of MUF spots to process  
  Dialog.create("Calibration");
  Dialog.addNumber("Number of spots", 10.);
  Dialog.show();
  N_spots = Dialog.getNumber();

// Manually select each spot and calculate the greyscale historgams
Hist=File.open(source_dir+"Histogram.txt");
nBins = 256;
print(Hist,  N_spots + nBins);
// calculate G, F and Sum(G*F) for each spot
l=0;
GF = newArray(N_spots); 	// product G*F for each spot
Gav = newArray(N_spots);	// total number of pixels with G > 0

waitForUser("Select 1st MUF spot and click OK");
getSelectionBounds(x, y, width, height);
// Calculate histogram counts[k], sum(G*F) and average G-value in each MUF spot
        Gtot = 0;
        Ftot = 0;
// First spot
        getHistogram(values, counts, nBins);
		for (k=0; k<nBins; k++) { 
			Gtot = Gtot + k*counts[k];
			Ftot = Ftot + counts[k];
			print(Hist, k+ " " +  counts[k]);
							}	
			GF[l]=Gtot;
			Gav[l] = Gtot/(Ftot -counts[0]);
			l=l+1;			

// all other spots
for (i = 1; i < N_spots; i++) {
makeRectangle(x, y, width, height);
waitForUser("Select next spot and click OK");
getSelectionBounds(x, y, width, height);
		for (k=0; k<nBins; k++) { 
			getHistogram(values, counts, nBins);
			Gtot = Gtot + k*counts[k];
			Ftot = Ftot + counts[k];
			print(Hist, k+ " " +  counts[k]);
							}	
						GF[l]=Gtot;
						Gav[l] = Gtot/(Ftot -counts[0]);
						l=l+1;			
	}

File.close(Hist); 

// Save results to Totgrey.txt
Totgrey=File.open(source_dir+"Totgrey.txt");
print(Totgrey,"MUF    G*F   Gaver");
			for(l=0; l<N_spots; l++) {
			   print(Totgrey, MUF[l] +" "+ GF[l] + " " + Gav[l]);				
			}

File.close(Totgrey); 

// Fit MUF = a*Sum(GF)
x = GF; y=MUF;
Fit.doFit("y = a*x", x, y);

print("b1="+d2s(Fit.p(0),-6));
Fit.plot();
